require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "ShortBlade"

ST.addWeaponCoreLines(KEY)

-- ShortBlade-specific: Jaw-stab chance multiplier per level
-- Source: PZWiki "Short Blade" → Proficiency levels (Chance to jaw stab multiplier).
-- L1..L10 = 103%..130% → we display as x1.03..x1.30
ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()
    local JAW_MULT = {1.03, 1.06, 1.09, 1.12, 1.15, 1.18, 1.21, 1.24, 1.27, 1.30}

    ctx.addSeparator()
    ctx.add(ST.getText("IGUI_DST_ShortBlade_val_JawStabMult", string.format("%.2f", JAW_MULT[lvl])))
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)